import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIGetTModelDetail2 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector tkv = new Vector();
		tkv.addElement("UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23");
		tkv.addElement("UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63");

		TModelDetail td = proxy.get_tModelDetail(tkv);

		Vector tv = td.getTModelVector();
		if (tv.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		System.out.println(tv.size()+" tmodel(s) found\n");
		for (int i = 0; i < tv.size(); i++) {
			TModel t = (TModel)tv.elementAt(i);
			System.out.println(t.getNameString());
			System.out.println(t.getTModelKey());
			System.out.println("\n");
		}
	}
}